// Copyright (c) 2010-2011 Quadralay Corporation.  All rights reserved.
//
// ePublisher 2010.4
// 2011-02-15
//
// Validated with JSLint <http://www.jslint.com/>
//

/*global window */

var Connect_Window = window;
Connect_Window.name = 'connect_main';

var Progress = { progress: 0 };

Progress.Reset = function() {
    // Reset progress
    //
    Progress.progress = 0;

    // Reset segments
    //
    var current_progress = 0;
    while (current_progress < 100) {
        current_progress += 10;

        var progress_segment = Connect_Window.document.getElementById('progress_' + current_progress);
        progress_segment.className = progress_segment.className.replace('ww_skin_progress_segment_complete', 'ww_skin_progress_segment_pending');
    }

    // Show progress
    //
    var progress_div = Connect_Window.document.getElementById('progress');
    progress_div.style.display = 'block';
};

Progress.Update = function(param_progress) {
    if (param_progress > Progress.progress) {
        if (param_progress <= 100) {
            while ((Progress.progress + 10) <= param_progress) {
                Progress.progress = Progress.progress + 10;

                var progress_segment = Connect_Window.document.getElementById('progress_' + Progress.progress);
                progress_segment.className = progress_segment.className.replace('ww_skin_progress_segment_pending', 'ww_skin_progress_segment_complete');
            }
        }
    }
};

Progress.Complete = function() {
    var progress_div = Connect_Window.document.getElementById('progress');
    progress_div.style.display = 'none';
};


function Tracker(param_element, param_callback) {
    this.element = param_element;
    this.callback = param_callback;
    this.snapshot = param_element.innerHTML;

    var this_tracker = this;
    this.Execute = function() {
                    try {
                        var snapshot = this_tracker.element.innerHTML;
                        if (snapshot !== this_tracker.snapshot) {
                            this_tracker.snapshot = snapshot;

                            // Invoke callback
                            //
                            param_callback();
                        }

                        // Continue
                        //
                        Connect_Window.setTimeout(function() { this_tracker.Execute(); }, 250);
                    }
                    catch (e) {
                        // Element must no longer be valid
                        //
                    }
                };
}


var Browser = { scrollbar_widthheight: null };


Browser.GetAJAX = function() {
    var result;

    try {
        // Firefox, Opera, Safari, Chrome
        //
        result = new Connect_Window.XMLHttpRequest();
    }
    catch (e1) {
        // IE
        //
        try {
            result = new Connect_Window.ActiveXObject('Msxml2.XMLHTTP');
        }
        catch (e2) {
            result = new Connect_Window.ActiveXObject('Microsoft.XMLHTTP');
        }
    }

    return result;
};

Browser.ContainsClass = function(param_className, param_class) {
    var result = false;

    if (
    // Next two lines of code are for Bug 14297. -Lief 27. April 2011 
        (param_className !== undefined)
         &&
        (param_className.length > 0)
         &&
        (param_class.length > 0)
       ) {
        // Exact match?
        //
        if (param_class === param_className) {
            result = true;
        }
        else {
            // Contains?
            //
            var index = param_className.indexOf(param_class);
            if (index >= 0) {
                if (index === 0) {
                    result = (param_className.charAt(param_class.length) === ' ');
                }
                else if (index === (param_className.length - param_class.length)) {
                    result = (param_className.charAt(index - 1) === ' ');
                }
                else {
                    result = ((param_className.charAt(index - 1) === ' ') && (param_className.charAt(index + param_class.length) === ' '));
                }
            }
        }
    }

    return result;
};

Browser.SameDocument = function(param_url_1, param_url_2) {
    var result = false;

    if (param_url_1 == param_url_2) {
        // Quick and dirty check
        //
        result = true;
    }
    else {
        // Try more in-depth test
        //
        var current_path = param_url_1;
        var desired_path = param_url_2;

        // Decompose hrefs
        //
        if (current_path.indexOf('#') !== -1) {
            current_path = current_path.substring(0, current_path.indexOf('#'));
        }
        if (desired_path.indexOf('#') !== -1) {
            desired_path = desired_path.substring(0, desired_path.indexOf('#'));
        }

        // Same document?
        //
        if (
            (desired_path == current_path)
             ||
            (decodeURI(desired_path) == current_path)
             ||
            (desired_path == decodeURI(current_path))
             ||
            (decodeURI(desired_path) == decodeURI(current_path))
           ) {
            result = true;
        }
    }

    return result;
};

Browser.SameHierarchy = function(param_base_url, param_test_url) {
    var result = false;

    if (param_test_url.indexOf(param_base_url) === 0) {
        result = true;
    }
    else {
        var decoded_base_url = decodeURI(param_base_url);

        if (param_test_url.indexOf(decoded_base_url) === 0) {
            result = true;
        }
        else {
            var decoded_test_url = decodeURI(param_test_url);

            if (decoded_test_url.indexOf(param_base_url) === 0) {
                result = true;
            }
            else {
                if (decoded_test_url.indexOf(decoded_base_url) === 0) {
                    result = true;
                }
            }
        }
    }

    return result;
};

Browser.RelativePath = function(param_base_url, param_test_url) {
    var result = '';

    if (param_test_url.indexOf(param_base_url) === 0) {
        result = param_test_url.substring(param_base_url.length);
    }
    else {
        var decoded_base_url = decodeURI(param_base_url);

        if (param_test_url.indexOf(decoded_base_url) === 0) {
            result = param_test_url.substring(decoded_base_url.length);
        }
        else {
            var decoded_test_url = decodeURI(param_test_url);

            if (decoded_test_url.indexOf(param_base_url) === 0) {
                result = decoded_test_url.substring(param_base_url.length);
            }
            else {
                if (decoded_test_url.indexOf(decoded_base_url) === 0) {
                    result = decoded_test_url.substring(decoded_base_url.length);
                }
            }
        }
    }

    return result;
};

Browser.ResolveURL = function(param_reference_page_url, param_url) {
    var  result;

    // Absolute URL?
    //
    if (param_url.indexOf('//') >= 0) {
        // Absolute URL
        //
        result = param_url;
    }
    else {
        // Relative URL
        //

        // Expand URL into components
        //
        var url_parts;
        if (param_url.indexOf('/') >= 0) {
            url_parts = param_url.split('/');
        }
        else {
            url_parts = [ param_url ];
        }
        var resolved_url_parts = param_reference_page_url.split('/');
        resolved_url_parts.length = resolved_url_parts.length - 1;

        // Process URL components
        //
        while (url_parts.length > 0) {
            var url_component = url_parts.pop();

            if (
                (url_component === '')
                 ||
                (url_component === '.')
               ) {
                // Ignore it
                //
            } else if (url_component === '..') {
                resolved_url_parts.pop();
            }
            else {
                resolved_url_parts.push(url_component);
            }
        }

        // Build resolved URL
        //
        result = resolved_url_parts.join('/');
    }

    return result;
}

Browser.GetDocument = function(param_iframe_or_window) {
    var result;

    try {
        // <iframe>?
        //
        result = param_iframe_or_window.contentWindow || param_iframe_or_window.contentDocument;
        if (result.document) {
            result = result.document;
        }
    }
    catch (e1) {
        try {
            // window?
            //
            result = param_iframe_or_window.document;
        }
        catch (e2) {
            // Give up!
            //
        }
    }

    return result;
};

Browser.GetScrollbarWidthHeight = function() {
    var result = Browser.scrollbar_widthheight;

    if (result === null) {
        // Initialize result
        //
        result = { width: 0, height: 0 };

        // Access info elements
        //
        var scrollbar_info = Connect_Window.document.getElementById('scrollbar_info');
        var scrollbar_info_content_width_1 = Connect_Window.document.getElementById('scrollbar_info_content_width_1');
        var scrollbar_info_content_width_2 = Connect_Window.document.getElementById('scrollbar_info_content_width_2');
        var scrollbar_info_container_width_2 = Connect_Window.document.getElementById('scrollbar_info_container_width_2');
        var scrollbar_info_content_height_1 = Connect_Window.document.getElementById('scrollbar_info_content_height_1');
        var scrollbar_info_content_height_2 = Connect_Window.document.getElementById('scrollbar_info_content_height_2');
        var scrollbar_info_container_height_2 = Connect_Window.document.getElementById('scrollbar_info_container_height_2');

        // Determine scrollbar width/height
        //
        var large;
        var small;

        // Width
        //
        large = scrollbar_info_content_width_1.offsetWidth;
        small = scrollbar_info_content_width_2.offsetWidth;
        if (small === large) {
            small = scrollbar_info_container_width_2.clientWidth;
        }
        result.width = (large - small);

        // Height
        //
        large = scrollbar_info_content_height_1.offsetHeight;
        small = scrollbar_info_content_height_2.offsetHeight;
        if (small === large) {
            small = scrollbar_info_container_height_2.clientHeight;
        }
        result.height = (large - small);

        // Remove scrollbar info elements
        //
        Connect_Window.document.body.removeChild(scrollbar_info);

        // Cache result
        //
        Browser.scrollbar_widthheight = result;
    }

    return result;
};

Browser.GetBrowserWidthHeight = function() {
    var result = { width: 0, height: 0 };

    // Determine browser width/height
    //
    if (
        (Connect_Window.document.documentElement !== undefined)
         &&
        (Connect_Window.document.documentElement.clientWidth !== 0)
       ) {
        result.width = Connect_Window.document.documentElement.clientWidth;
        result.height = Connect_Window.document.documentElement.clientHeight;
    }
    else {
        result.width = Connect_Window.document.body.clientWidth;
        result.height = Connect_Window.document.body.clientHeight;
    }

    return result;
};

Browser.GetWindowContentWidthHeight = function(param_window) {
    var result = { width: 0, height: 0 };

    // Determine iframe width/height
    //
    var window_document = Browser.GetDocument(param_window);
    if (window_document !== undefined) {
        // Default width/height info
        //
        var element = window_document.body;
        result.width = element.offsetWidth;
        result.height = element.offsetHeight;

        if (
            (window_document.documentElement !== undefined)
             &&
            (window_document.documentElement.offsetWidth !== 0)
           ) {
            // Improve upon existing width/height info
            //
            if (Connect_Window.navigator.userAgent.indexOf('MSIE') === -1) {
                element = window_document.documentElement;
                if (element.offsetWidth > result.width) {
                    result.width = element.offsetWidth;
                }
                if (element.offsetHeight > result.height) {
                    result.height = element.offsetHeight;
                }
            }
        }
    }

    return result;
};

Browser.GetIFrameContentWidthHeight = function(param_iframe) {
    var result;

    // Determine iframe width/height
    //
    result = Browser.GetWindowContentWidthHeight(param_iframe);

    return result;
};

Browser.GetElementWidthHeight = function(param_element) {
    var result = { width: 0, height: 0 };

    // Determine content width/height
    //
    if (param_element.scrollWidth !== undefined) {
        result.width = param_element.scrollWidth;
        result.height = param_element.scrollHeight;
    }

    return result;
};

Browser.FindParentWithTagName = function(param_element, param_tag_name) {
    var result = null;

    var parent_element = param_element;
    while (
           (result === null)
            &&
           (parent_element !== undefined)
            &&
           (parent_element !== null)
            &&
           (parent_element.parentNode !== null)
          ) {
        // Found target element?
        //
        if (parent_element.parentNode.nodeName.toLowerCase() == param_tag_name) {
            // Success!
            //
            result = parent_element.parentNode;
        }

        // Advance
        //
        parent_element = parent_element.parentNode;
    }

    return result;
};

Browser.FirstChildElement = function(param_element) {
    var result = null;

    if (
        (param_element.firstChild !== undefined)
         &&
        (param_element.firstChild !== null)
       ) {
        var child_node = param_element.firstChild;
        while (
               (child_node !== null)
              ) {
            if (child_node.nodeType === 1) {
                result = child_node;
                break;
            }
            else {
                child_node = Browser.NextSiblingElement(child_node);
            }
        }
    }

    return result;
};

Browser.FirstChildElementWithTagName = function(param_element, param_tag_name) {
    var result = null;

    if (
        (param_element.firstChild !== undefined)
         &&
        (param_element.firstChild !== null)
       ) {
        var child_node = param_element.firstChild;
        while (
               (child_node !== null)
              ) {
            if (
                (child_node.nodeType === 1)
                 &&
                (child_node.nodeName.toLowerCase() === param_tag_name)
               ) {
                result = child_node;
                break;
            }
            else {
                child_node = Browser.NextSiblingElement(child_node);
            }
        }
    }

    return result;
};

Browser.PreviousSiblingElement = function(param_element) {
    var result = null;

    var current_element = param_element;
    while (
           (current_element.previousSibling !== undefined)
            &&
           (current_element.previousSibling !== null)
          ) {
        if (current_element.previousSibling.nodeType === 1) {
            result = current_element.previousSibling;
            break;
        }

        current_element = current_element.previousSibling;
    }

    return result;
};

Browser.NextSiblingElement = function(param_element) {
    var result = null;

    var current_element = param_element;
    while (
           (current_element.nextSibling !== undefined)
            &&
           (current_element.nextSibling !== null)
          ) {
        if (current_element.nextSibling.nodeType === 1) {
            result = current_element.nextSibling;
            break;
        }

        current_element = current_element.nextSibling;
    }

    return result;
};

Browser.PreviousSiblingElementWithTagName = function(param_element, param_tag_name) {
    var result = null;

    result = Browser.PreviousSiblingElement(param_element);
    while (
           (result !== null)
            &&
           (result.nodeName.toLowerCase() !== param_tag_name)
          ) {
        result = Browser.PreviousSiblingElement(result);
    }

    return result;
};

Browser.NextSiblingElementWithTagName = function(param_element, param_tag_name) {
    var result = null;

    result = Browser.NextSiblingElement(param_element);
    while (
           (result !== null)
            &&
           (result.nodeName.toLowerCase() !== param_tag_name)
          ) {
        result = Browser.NextSiblingElement(result);
    }

    return result;
};

Browser.GetAttribute = function(param_element, param_attribute_name) {
    var result = null;

    // Notes on browser compatibility
    // http://help.dottoro.com/ljhutuuj.php
    //
    if (param_element.getAttribute !== undefined) {
        result = param_element.getAttribute(param_attribute_name);
    }
    else if (param_element.getPropertyValue !== undefined) {
        result = param_element.getPropertyValue(param_attribute_name);
    }
    else {
        if (
             (param_element[param_attribute_name] !== undefined)
              &&
             (param_element[param_attribute_name] !== null)
           ) {
            result = param_element[param_attribute_name];
        }
    }

    return result;
};

Browser.SetAttribute = function(param_element, param_attribute_name, param_value) {
    // Notes on browser compatibility
    // http://help.dottoro.com/ljhutuuj.php
    //
    if (param_element.setAttribute !== undefined) {
        param_element.setAttribute(param_attribute_name, param_value);
    }
    else if (param_element.setProperty !== undefined) {
        param_element.setProperty(param_attribute_name, param_value);
    }
    else {
        param_element[param_attribute_name] = param_value;
    }
};

Browser.RemoveAttribute = function(param_element, param_attribute_name, param_empty_value) {
    // Attribute exists?
    //
    var attribute_value = Browser.GetAttribute(param_element, param_attribute_name);
    if (
        (attribute_value !== null)
         &&
        (attribute_value != param_empty_value)
       ) {
        // Notes on browser compatibility
        // http://help.dottoro.com/ljhutuuj.php
        //
        if (param_element.removeAttribute !== undefined) {
            param_element.removeAttribute(param_attribute_name);
        }
        else if (param_element.removeProperty !== undefined) {
            param_element.removeProperty(param_attribute_name);
        }
        else {
            param_element[param_attribute_name] = param_empty_value;
        }
    }
};

Browser.GetLinkRelHREF = function(param_document, param_rel) {
    var result = '';

    var link_elements = param_document.getElementsByTagName('link');
    var index;
    for (index = 0 ; index < link_elements.length ; index++) {
        var link_element = link_elements[index];
        if (link_element.rel === param_rel) {
            // HREF defined?
            //
            if (link_element.href !== undefined) {
                result = link_element.href;
            }
            break;
        }
    }

    return result;
};

Browser.ApplyToChildElementsWithTagName = function(param_element, param_tag_name, param_process) {
    var elements = param_element.getElementsByTagName(param_tag_name);
    var index;
    for (index = 0 ; index < elements.length ; index++) {
        var element = elements[index];

        param_process(element);
    }
};

Browser.TrackSubtreeChanges = function(param_element, param_callback) {
    if (param_element.addEventListener !== undefined) {
        param_element.addEventListener('DOMSubtreeModified', param_callback, false);
    }
    if (param_element.attachEvent !== undefined) {
        param_element.attachEvent('DOMSubtreeModified', param_callback);
    }

    // Address IE short-comings
    //
    if (Connect_Window.navigator.userAgent.indexOf('MSIE') !== -1) {
        // Periodically track changes
        //
        var tracker = new Tracker(param_element, param_callback);
        Connect_Window.setTimeout(tracker.Execute, 1);
    }
};

Browser.TrackDocumentChanges = function(param_document, param_callback) {
    Browser.TrackSubtreeChanges(param_document.body, param_callback);
};


// AJAXData
//

function AJAXData_Object(param_entries, param_get_url, param_progress, param_success, param_complete) {
    this.entries = param_entries;
    this.get_url = param_get_url;
    this.progress = param_progress;
    this.success = param_success;
    this.complete = param_complete;
    this.index = 0;
    this.ajax_avoid_304 = false;

    this.Execute = AJAXData_Execute;
}

AJAXData_Execute = function() {
    var this_ajaxdata = this;
    if (this_ajaxdata.index < this_ajaxdata.entries.length) {
        // Load entry
        //
        var entry = this_ajaxdata.entries[this_ajaxdata.index];
        var ajax = Browser.GetAJAX();

        ajax.onreadystatechange = function () {
            if (ajax.readyState === 4) {
                // Entry retrieved
                //
                if (ajax.status === 200) {
                    // Success!
                    //
                    this_ajaxdata.success(entry, ajax);

                    // Update progress
                    //
                    this_ajaxdata.index += 1;
                    this_ajaxdata.progress((this_ajaxdata.index / this_ajaxdata.entries.length) * 100);
                }
                else if (ajax.status === 304) {
                    // Already trying to work around 304s?
                    //
                    if (this_ajaxdata.ajax_avoid_304) {
                        // Keep moving forward
                        //
                        this_ajaxdata.index += 1;
                        this_ajaxdata.progress((this_ajaxdata.index / this_ajaxdata.entries.length) * 100);
                    }
                    else {
                        // Retry
                        //
                        this_ajaxdata.ajax_avoid_304 = true;
                    }
                }

                // Load next entry
                //
                Connect_Window.setTimeout(function() { this_ajaxdata.Execute(); }, 1);
            }
        };

        // Avoid 304 (not modified) responses
        //
        var request_url = this_ajaxdata.get_url(entry);
        if (this_ajaxdata.ajax_avoid_304) {
            var moment = new Date();
            request_url += '?moment=' + moment.getTime();
        }

        // Request entry
        //
        ajax.open('GET', request_url, true);
        ajax.send(null);
    }
    else {
        // Entries loaded!
        //
        this_ajaxdata.complete();
    }
};


// Panel
//

function Panel_Object(param_window) {
    this.window = param_window;
    this.panel_frame = this.window.document.getElementById('panel_frame');
    this.panel_content = this.window.document.getElementById('panel_content');
    this.navigation_div_left = this.window.document.getElementById('navigation_div_left');
    this.page_div = this.window.document.getElementById('page_div');

    this.Visible = Panel_Visible;
    this.Show = Panel_Show;
    this.Hide = Panel_Hide;
    this.Display = Panel_Display;
}

Panel_Visible = function() {
    var result = (this.panel_frame.style.display === 'block');

    return result;
};

Panel_Show = function() {
    if ( ! this.Visible()) {
        // Configure panel
        //
        this.page_div.style.visibility = 'hidden';
        this.navigation_div_left_visibility = this.navigation_div_left.style.visibility;
        this.navigation_div_left.style.visibility = 'hidden';
        this.panel_frame.style.display = 'block';
    }
};

Panel_Hide = function() {
    if (this.Visible()) {
        // Teardown
        //
        if (
            (this.teardown !== undefined)
             &&
            (this.teardown !== null)
           ) {
            this.teardown(this.window, this.panel_content);
            this.teardown = undefined;
        }

        // Hide panel
        //
        this.panel_frame.style.display = 'none';
        this.navigation_div_left.style.visibility = this.navigation_div_left_visibility;
        this.page_div.style.visibility = 'visible';
    }
};

Panel_Display = function(param_setup, param_teardown) {
    // Setup
    //
    param_setup(this.window, this.panel_content);

    // Configure teardown
    //
    this.teardown = param_teardown;

    // Show!
    //
    var this_panel = this;
    this.window.setTimeout(function() { this_panel.Show(); }, 1);
};


// Lightbox
//

function Lightbox_Object() {
    this.lightbox_background = Connect_Window.document.getElementById('lightbox_background');
    this.lightbox_frame = Connect_Window.document.getElementById('lightbox_frame');
    this.lightbox_content = Connect_Window.document.getElementById('lightbox_content');
    this.lightbox_close = Connect_Window.document.getElementById('lightbox_close');
    this.teardown = undefined;

    var this_lightbox = this;
    this.page_iframe = Connect_Window.document.getElementById('page_iframe');
    this.lightbox_close.onclick = function() { this_lightbox.Hide(); };

    this.Show = Lightbox_Show;
    this.Hide = Lightbox_Hide;
    this.Display = Lightbox_Display;
}

Lightbox_Show = function() {
    var browser_widthheight;
    var lightbox_frame_widthheight;
    var lightbox_frame_left;
    var lightbox_frame_top;

    // Calculate position
    //
    browser_widthheight = Browser.GetBrowserWidthHeight();
    lightbox_frame_widthheight = Browser.GetElementWidthHeight(this.lightbox_frame);
    lightbox_frame_left = Math.floor((browser_widthheight.width - lightbox_frame_widthheight.width) / 2);
    if (lightbox_frame_left < 0) {
        lightbox_frame_left = 0;
    }
    lightbox_frame_top = Math.floor((browser_widthheight.height - lightbox_frame_widthheight.height) / 2);
    if (lightbox_frame_top < 0) {
        lightbox_frame_top = 0;
    }

    // Set up the background
    //
    var window_content_widthheight = Browser.GetWindowContentWidthHeight(Connect_Window);
    var background_height = window_content_widthheight.height;
    if (browser_widthheight.height > background_height) {
        background_height = browser_widthheight.height;
    }
    if (lightbox_frame_widthheight.height > background_height) {
        background_height = lightbox_frame_widthheight.height;
    }
    var page_widthheight = Browser.GetIFrameContentWidthHeight(this.page_iframe);
    if (page_widthheight.height > background_height) {
        background_height = page_widthheight.height;
    }
    this.lightbox_background.style.top = '0px';
    this.lightbox_background.style.height = '' + background_height + 'px';
    this.lightbox_background.style.display = 'block';

    // Configure the frame
    //
    this.lightbox_frame.style.left = '' + lightbox_frame_left + 'px';
    this.lightbox_frame.style.top = '' + lightbox_frame_top + 'px';
    this.lightbox_frame.style.visibility = 'visible';
};

Lightbox_Hide = function() {
    // Hide lightbox
    //
    this.lightbox_frame.style.visibility = 'hidden';
    this.lightbox_frame.style.top = '0px';
    this.lightbox_frame.style.left = '0px';
    this.lightbox_background.style.display = 'none';

    // Teardown
    //
    if (
        (this.teardown !== undefined)
         &&
        (this.teardown !== null)
       ) {
        this.teardown(this.lightbox_content);
        this.teardown = undefined;
    }
};

Lightbox_Display = function(param_setup, param_teardown) {
    // Setup
    //
    param_setup(this.lightbox_content);

    // Configure teardown
    //
    this.teardown = param_teardown;

    // Show!
    //
    var this_lightbox = this;
    Connect_Window.setTimeout(function() { this_lightbox.Show(); }, 1);
};


var Connect = {};

Connect.OnLoad = function() {
    var prev_url_header_end = Connect_Window.location.href.indexOf(':');
    var url_header_end = Connect_Window.location.href.indexOf('/', prev_url_header_end + 1);
    while ((prev_url_header_end + 1) == url_header_end) {
        prev_url_header_end = url_header_end;
        url_header_end = Connect_Window.location.href.indexOf('/', prev_url_header_end + 1);
    }
    var url_header = Connect_Window.location.href.substring(0, url_header_end);
    var base_pathname = Connect_Window.location.pathname.substring(0, Connect_Window.location.pathname.lastIndexOf('/') + 1);
    var base_url = url_header + base_pathname;
    var splash_page_url = base_url + 'connect/splash.html';

    Connect.base_url = base_url;
    Connect.default_page_url = splash_page_url;
    Connect.search_page_url = base_url + 'connect/search.html';
    Connect.show_first_document = false;
    Connect.layout_wide = false;
    Connect.adjust_for_content_size_timeout = null;
    Connect.ajax_avoid_304 = false;
    Connect.parcels_loaded = false;
    Connect.page_loading = false;
    Connect.hash = '';
    Connect.parcel_anchors = [];
    Connect.parcel_ix = [];
    Connect.parcel_title = {};
    Connect.navigation_width = 200;
    // Changing the default navigation_minimum_page_width from 800. -Lief 28. April 2011
    Connect.navigation_minimum_page_width = 1025;
    Connect.lightbox_min_pixel_margin = 48;
    Connect.disqus_id = '';
    Connect.email = '';
    Connect.toc_class_states = null;
    Connect.search_input = null;
    Connect.button_behavior_expression = new RegExp('ww_behavior_[a-z]+', 'g');
    Connect.buttons = {};
    Connect.globe_enabled = false;

    Connect.link_bridge = {
        last_link: null,
        Next: {},
        Prev: {},
        HREFs: { 'splash': splash_page_url },
        Track: function(param_first_link, param_last_link) {
            var firstPageID = param_first_link.id.replace(/\:first$/, '');
            var lastPageID = param_last_link.id.replace(/\:last$/, '');

            // Associate previous/next and handle no splash
            //
            if (this.last_link === null) {
                if (Connect.show_first_document) {
                    Connect.default_page_url = param_first_link.href;
                }
                else {
                    this.Prev[firstPageID] = 'splash';
                    this.Next['splash'] = firstPageID;
                }
            }
            else {
                var lastLinkID = this.last_link.id.replace(/\:last$/, '');
                this.Prev[firstPageID] = lastLinkID;
                this.Next[lastLinkID] = firstPageID;
            }

            // Map ids to URIs
            //
            this.HREFs[firstPageID] = param_first_link.href;
            this.HREFs[lastPageID] = param_last_link.href;
  
            // Remember last link loaded
            //
            this.last_link = param_last_link;
        },

        GetPrev: function(param_page_id) {
            var result = null;

            if (this.Prev[param_page_id] !== undefined) {
                result = this.HREFs[this.Prev[param_page_id]];
            }

            return result;
        },

        GetNext: function(param_page_id) {
            var result = null;

            if (this.Next[param_page_id] !== undefined) {
                result = this.HREFs[this.Next[param_page_id]];
            }

            return result;
        },
        
        Get: function(param_type, param_page_id) {
            var result = null;
            
            if (param_type === 'Prev') {
                result = this.GetPrev(param_page_id);
            }
            else if (param_type === 'Next') {
                result = this.GetNext(param_page_id);
            }
            
            return result;
        }
    };

    // Layout offsets
    //
    Connect.layout_wide_offset = 0;
    Connect.layout_narrow_offset = 0;
    Connect.layout_current_offset = 0;
    var css_rules = Connect_Window.document.styleSheets[0].cssRules;
    if (css_rules === undefined) {
        css_rules = Connect_Window.document.styleSheets[0].rules;
    }
    var css_rules_index;
    for (css_rules_index = 0 ; css_rules_index < css_rules.length ; css_rules_index++) {
        var css_rule = css_rules[css_rules_index];

        if (css_rule.selectorText === '.layout_wide') {
            Connect.layout_wide_offset += parseInt(css_rule.style.paddingLeft, 10);
            Connect.layout_wide_offset += parseInt(css_rule.style.paddingRight, 10);
        }
        else if (css_rule.selectorText === '.layout_narrow') {
            Connect.layout_narrow_offset += parseInt(css_rule.style.paddingLeft, 10);
            Connect.layout_narrow_offset += parseInt(css_rule.style.paddingRight, 10);
        }
    }

    // Cache <div>s
    //
    Connect.layout_div = Connect_Window.document.getElementById('layout_div');
    Connect.toolbar_div = Connect_Window.document.getElementById('toolbar_div');
    Connect.presentation_div = Connect_Window.document.getElementById('presentation_div');
    Connect.parcels_div = Connect_Window.document.getElementById('parcels');
    Connect.page_div = Connect_Window.document.getElementById('page_div');
    Connect.page_iframe = Connect_Window.document.getElementById('page_iframe');
    Connect.navigation_div = Connect_Window.document.getElementById('navigation_div');
    Connect.navigation_div_left = Connect_Window.document.getElementById('navigation_div_left');
    Connect.navigation_div_bottom = Connect_Window.document.getElementById('navigation_div_bottom');
    Connect.panels_div = Connect_Window.document.getElementById('panels');
    Connect.panel_progress_div = Connect_Window.document.getElementById('panel_progress');
    Connect.toc_div = Connect_Window.document.getElementById('toc');
    Connect.index_div = Connect_Window.document.getElementById('index');
    Connect.search_div = Connect_Window.document.getElementById('search');
    Connect.search_iframe = Connect_Window.document.getElementById('search_iframe');

    // Size content <div>
    //
    Connect_Window.onresize = Connect.OnResize;

    // Panel
    //
    Connect.Panel = new Panel_Object(Connect_Window);

    // Lightbox
    //
    Connect.Lightbox = new Lightbox_Object();

    // Load parcels
    //
    Connect.parcel_anchors = [];
    Connect.parcel_context_ids = {};
    Connect.parcel_prefixes = {};
    Connect.parcel_prefixes[Connect.base_url + 'connect/'] = true;
    Connect.toc_div.innerHTML = Connect.parcels_div.innerHTML;
    Connect.parcels_div.innerHTML = '';
    Connect.parcels_div.style.display = 'none';
    var parcel_anchors = Connect.toc_div.getElementsByTagName('a');
    if (parcel_anchors.length === 0) {
        parcel_anchors = Connect_Window.document.links;
    }
    var index;
    for (index = 0 ; index < parcel_anchors.length ; index++) {
        Connect.parcel_anchors[Connect.parcel_anchors.length] = parcel_anchors[index];
    }
    Connect.Parcel_Load();
};

Connect.AddParcel = function(param_parcel_context,
                             param_parcel_id,
                             param_parcel_url,
                             param_parcel_title) {
    var parcel_directory_url = param_parcel_url.substring(0, param_parcel_url.lastIndexOf('.'));

    // Track context
    //
    Connect.parcel_context_ids[param_parcel_context] = param_parcel_id;

    // Include original file and directory prefix
    //
    Connect.parcel_prefixes[param_parcel_url] = true;
    Connect.parcel_prefixes[parcel_directory_url] = true;
    Connect.parcel_ix.push({ 'id': param_parcel_id, 'url': parcel_directory_url + '_ix.html' });
    Connect.parcel_title[param_parcel_id] = param_parcel_title;
};

Connect.KnownParcelURL = function(param_url) {
    var result = false;

    var parcel_base_url;
    for (parcel_base_url in Connect.parcel_prefixes) {
        if (Browser.SameHierarchy(parcel_base_url, param_url)) {
            result = true;
            break;
        }
    }

    return result;
};

Connect.AdjustLayoutForBrowserSize = function() {
    // Adjust navigation based on available space
    //
    var browser_widthheight = Browser.GetBrowserWidthHeight();
    var scrollbar_widthheight = Browser.GetScrollbarWidthHeight();
    var previous_layout_wide = Connect.layout_wide;
    Connect.layout_wide = ((browser_widthheight.width - Connect.layout_wide_offset - scrollbar_widthheight.width) >= Connect.navigation_minimum_page_width);

    // Layout changed?
    //
    if (Connect.layout_wide != previous_layout_wide) {
        if (Connect.layout_wide) {
            // Display context TOC on left
            //
            Connect.navigation_div_left.appendChild(Connect.navigation_div);

            Connect.navigation_div_left.style.width = '' + Connect.navigation_width + 'px';
            if (Connect.navigation_width > 0) {
                Connect.navigation_div_left.style.display = 'block';
            }
            else {
                Connect.navigation_div_left.style.display = 'none';
            }

            Connect.navigation_div_bottom.style.display = 'none';

            // Layout
            //
            Connect.layout_div.className = 'layout_wide';
            Connect.layout_current_offset = Connect.layout_wide_offset;
        }
        else {
            // Display context TOC on bottom
            //
            Connect.navigation_div_bottom.appendChild(Connect.navigation_div);

            Connect.navigation_div_left.style.display = 'none';
            Connect.navigation_div_left.style.width = '0px';

            Connect.navigation_div_bottom.style.display = 'none';

            // Layout
            //
            Connect.layout_div.className = 'layout_narrow';
            Connect.layout_current_offset = Connect.layout_narrow_offset;
        }

        // Update toolbar buttons
        //
        var toolbar_buttons = Connect.toolbar_div.getElementsByTagName('span');
        var left_button;
        var right_button;
        var index;
        for (index = 0 ; index < toolbar_buttons.length ; index++) {
            var toolbar_button = toolbar_buttons[index];
            if (
                (Browser.ContainsClass(toolbar_button.className, 'ww_skin_toolbar_button_left'))
                 ||
                (Browser.ContainsClass(toolbar_button.className, 'ww_skin_toolbar_button_center'))
                 ||
                (Browser.ContainsClass(toolbar_button.className, 'ww_skin_toolbar_button_right'))
               ) {
                if (left_button === undefined) {
                    left_button = toolbar_button;
                }
                right_button = toolbar_button;
            }
        }
        if (left_button !== undefined) {
            if (Connect.layout_wide) {
                left_button.className += ' ww_skin_toolbar_left_background';
            }
            else {
                left_button.className = left_button.className.replace(' ww_skin_toolbar_left_background', '');
            }
        }
        if (right_button !== undefined) {
            if (Connect.layout_wide) {
                right_button.className += ' ww_skin_toolbar_right_background';
            }
            else {
                right_button.className = right_button.className.replace(' ww_skin_toolbar_right_background', '');
            }
        }

        // Update search form
        //
        if (Connect.search_input !== null) {
            if (Connect.layout_wide) {
                if ( ! Connect.Panel.Visible()) {
                    Connect.search_input.style.display = 'inline';
                }
                else {
                    Connect.search_input.style.display = 'none';
                }
            }
            else {
                Connect.search_input.style.display = 'none';
            }
        }
    }
};

Connect.AdjustForContentSize = function() {
    try {
        // Halt adjustment requests
        //
        if (Connect.adjust_for_content_size_timeout !== null) {
            Connect_Window.clearTimeout(Connect.adjust_for_content_size_timeout);
            Connect.adjust_for_content_size_timeout = null;
        }

        // Adjust navigation based on available space
        //
        Connect.AdjustLayoutForBrowserSize();

        // Determine navigation width
        //
        var navigation_widthheight = Browser.GetElementWidthHeight(Connect.navigation_div_left);

        // Set content width
        //
        var browser_widthheight = Browser.GetBrowserWidthHeight();
        Connect.presentation_div.style.width = '' + (browser_widthheight.width - Connect.layout_current_offset)+ 'px';
        var target_page_width = browser_widthheight.width - navigation_widthheight.width - Connect.layout_current_offset;
        Connect.page_div.style.width = '' + target_page_width + 'px';

        // Adjust content width
        //
        var page_widthheight = Browser.GetIFrameContentWidthHeight(Connect.page_iframe);
        
        // WebWorks Study Hall for Bug 14428. -Lief/Jesse 27. April 2011
        //
        if (page_widthheight.width >900) {
            Connect.presentation_div.style.width = '900px';
            Connect.page_div.style.width = '900px';
        }
        // Original code that was replaced with the above.
	//
	//if (page_widthheight.width > target_page_width) {
        //    Connect.presentation_div.style.width = '' + (navigation_widthheight.width + page_widthheight.width) + 'px';
        //    Connect.page_div.style.width = '' + page_widthheight.width + 'px';
        //}

        // Set content height
        //
        Connect_Window.setTimeout(Connect.AdjustForContentSize_Height, 1);
    }
    catch (e) {
        // Content page must not be loaded yet
        //
    }
};

Connect.AdjustForContentSize_Height = function() {
    // Set content height
    //
    var page_widthheight = Browser.GetIFrameContentWidthHeight(Connect.page_iframe);
    Connect.page_iframe.style.height = '' + page_widthheight.height + 'px';
};

Connect.OnResize = function() {
    if ( ! Connect.page_loading) {
        // Adjust for content size
        //
        if (Connect.adjust_for_content_size_timeout !== null) {
            Connect_Window.clearTimeout(Connect.adjust_for_content_size_timeout);
        }
        Connect.adjust_for_content_size_timeout = Connect_Window.setTimeout(Connect.AdjustForContentSize, 100);
    }
};

Connect.Parcel_Load = function() {
    var ajaxdata = new AJAXData_Object(Connect.parcel_anchors,
            function(param_entry) {
                return param_entry.href;
            },
            function(param_percent) {
                Progress.Update(param_percent);
            },
            function(param_entry, param_ajax) {
                // Access parcel
                //
                var parcel_div = Connect_Window.document.createElement('div');
                parcel_div.style.visibility = 'hidden';
                parcel_div.innerHTML = param_ajax.responseText;
                Connect_Window.document.body.appendChild(parcel_div);

                // Add to collection of valid parcels
                //
                var context_and_id = param_entry.id.split(':');
                var parcel_context = context_and_id[0];
                var parcel_id = context_and_id[1];
                Connect.AddParcel(parcel_context, parcel_id, param_entry.href, param_entry.innerHTML);

                // TOC
                //
                var parcel_toc_div_id = 'toc:' + parcel_id;
                var parcel_toc_div = Connect_Window.document.getElementById(parcel_toc_div_id);
                if (parcel_toc_div !== null) {
                    var toc_ul = Browser.FirstChildElementWithTagName(parcel_toc_div, 'ul');
                    if (toc_ul !== null) {
                        // Extract TOC data
                        //
                        param_entry.parentNode.parentNode.appendChild(toc_ul);
                    }
                }

                // Data
                //
                var parcel_data_div_id = 'data:' + parcel_id;
                var parcel_data_div = Connect_Window.document.getElementById(parcel_data_div_id);
                if (parcel_data_div !== null) {
                    Connect.parcels_div.appendChild(parcel_data_div);

                    // Add "bridge" links
                    //
                    var first_page_div = Connect_Window.document.getElementById('page:' + parcel_id + ':first');
                    var last_page_div = Connect_Window.document.getElementById('page:' + parcel_id + ':last');
                    var first_page_a = Browser.FirstChildElementWithTagName(first_page_div, 'a');
                    var last_page_a = Browser.FirstChildElementWithTagName(last_page_div, 'a');
                    Connect.link_bridge.Track(first_page_a, last_page_a);
                }

                // Remove parcel data
                //
                Connect_Window.document.body.removeChild(parcel_div);

                // Disable parcel link
                //
                Browser.RemoveAttribute(param_entry, 'href', '');
            },
            function() {
                // Parcels loaded!
                //
                Connect.parcels_loaded = true;

                // Configure TOC levels
                //
                Connect.ConfigureTOCLevels(Connect.toc_div, true);

                // Intercept all clicks
                //
                Browser.ApplyToChildElementsWithTagName(Connect.toc_div, 'a', function(param_link) {
                        param_link.onclick = Connect.NavigationLink;

                        // Track container clicks as well
                        //
                        param_link.parentNode.onclick = Connect.NavigationEntryClick;
                    }
                );

                // This section is part of the fix for Bug 14297. -Lief 27. April 2011
		// Track folder clicks
                //
                Browser.ApplyToChildElementsWithTagName(Connect.toc_div, 'div', function(param_div) {
                        if (Browser.ContainsClass(param_div.className, 'ww_skin_toc_folder')) {
                            param_div.onclick = Connect.NavigationEntryClick;
                        }
                    }
                );

                // Intercept toolbar links
                //
                Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'a', function(param_link) {
                        param_link.onclick = Connect.ToolbarLink;

                        // Track buttons
                        //
                        var match = param_link.className.match(Connect.button_behavior_expression);
                        if (match !== null) {
                            var button_key = match[0];
                            var button_span = Browser.FindParentWithTagName(param_link, 'span');
                            if (button_span !== null) {
                                Connect.buttons[button_key] = button_span;
                            }
                        }
                    }
                );

                // Handle toolbar search
                //
                if (Connect_Window.navigator.userAgent.indexOf('MSIE') === -1) {
                    // Use toolbar search form
                    //
                    Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'form', function(param_form) {
                            if (Browser.ContainsClass(param_form.className, 'ww_skin_search_form')) {
                                param_form.onsubmit = function() { Connect.Button_Search(); return false; };
                            }
                        }
                    );
                    Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'input', function(param_input) {
                            if (Browser.ContainsClass(param_input.className, 'ww_skin_search_input')) {
                                Connect.search_input = param_input;
                            }
                        }
                    );
                }
                else {
                    // Eliminate toolbar search form for IE
                    //
                    Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'form', function(param_form) {
                            // Promote button to form peer
                            //
                            var parent_element = param_form.parentNode;
                            var button_span = Connect.buttons['ww_behavior_search'];
                            if (button_span !== undefined) {
                                parent_element.insertBefore(button_span, param_form);
                            }

                            // Remove search form
                            //
                            parent_element.removeChild(param_form);
                        }
                    );
                }

                // Display specified document
                //
                if (Connect_Window.location.hash.length > 0) {
                    // Use hash
                    //
                    Connect.DisplaySpecifiedDocument();
                }
                else {
                    // Process default page load
                    //
                    Connect.DisplayPage(Connect.default_page_url);
                }

                // Check for hash changes
                //
                if ('onhashchange' in window) {
                    Connect_Window.onhashchange = Connect.HashChanged;
                }

                // Done!
                //
                Progress.Complete();

                // Show
                //
                Connect.presentation_div.style.visibility = 'visible';
            }
        );
    ajaxdata.Execute();
};

Connect.DisplaySpecifiedDocument = function() {
    if ( ! Connect.page_loading) {
        var page_document = Browser.GetDocument(Connect.page_iframe);
        if (page_document !== undefined) {
            // Hide panel
            //
            Connect.Panel.Hide();

            // Reset navigation
            //
            Connect.navigation_div.innerHTML = '&#160;';

            // Start page load
            //
            if (
                (Connect_Window.location.hash === '')
                 ||
                (Connect_Window.location.hash === '#')
               ) {
                Connect.DisplayPage(Connect.default_page_url);
            }
            else if (
                     (Connect_Window.location.hash.indexOf('#context/') === 0)
                    ) {
                // Context/topic requested
                //
                var context_and_topic = Connect_Window.location.hash.substring(9);
                var topic_index = context_and_topic.indexOf('/');
                var context = context_and_topic.substring(0, topic_index);
                var topic = context_and_topic.substring(topic_index + 1);

                // Resolve context
                //
                if (
                    (context.length > 0)
                     &&
                    (topic.length > 0)
                     &&
                    (context in Connect.parcel_context_ids)
                   ) {
                    var parcel_id = Connect.parcel_context_ids[context];
                    var topic_id = 'topic:' + parcel_id + ':' + topic;
                    var topic_anchor = Connect_Window.document.getElementById(topic_id);
                    if (topic_anchor !== null) {
                        // Found topic!
                        //
                        Connect.DisplayPage(topic_anchor.href);
                    }
                }
            }
            else if (Connect_Window.location.hash.indexOf('#search/') === 0) {
                // Search enabled?
                //
                if (Connect.search_div !== null) {
                    // Page requested
                    //
                    var search_words_parameter = Connect_Window.location.hash.substring(8);
                    var search_words = decodeURI(search_words_parameter);

                    // Display search and default page on close
                    //
                    Connect.Button_Search(search_words, Connect.default_page_url);
                }
            }
            else if (Connect_Window.location.hash.indexOf('#page/') === 0) {
                // Page requested
                //
                var page_base_relative_url = Connect_Window.location.hash.substring(6);

                // Ignore top-level files
                //
                if (page_base_relative_url.indexOf('/') >= 0) {
                    // Build secure URI
                    //
                    page_base_relative_url = decodeURI(page_base_relative_url);
                    page_base_relative_url = page_base_relative_url.replace(/[\\<>:;"']|%5C|%3C|%3E|%3A|%3B|%22|%27/gi, '');

                    var page_url = Connect.base_url + page_base_relative_url;
                    Connect.DisplayPage(page_url);
                }
                else {
                    // Display default page
                    //
                    Connect.DisplayPage(Connect.default_page_url);
                }
            }
        }
    }
};

Connect.HashChanged = function() {
    if (Connect_Window.location.hash != Connect.hash) {
        // Update document
        //
        Connect.DisplaySpecifiedDocument();
    }
};

Connect.LocateTOCEntry = function() {
    var result = null;

    // See if page exists in TOC
    //
    var page_document = Browser.GetDocument(Connect.page_iframe);
    if (page_document !== undefined) {
        var page_id = page_document.body.id;

        // Page ID defined?
        //
        if (
            (typeof(page_id) === 'string')
             &&
            (page_id.length > 0)
           ) {
            // Try instant lookup with document hash
            //
            if (
                (page_document.location.hash.length > 1)
                 &&
                (page_document.location.hash.charAt(0) === '#')
               ) {
                var possible_toc_entry_id = page_id + ':' + page_document.location.hash.substring(1);
                var possible_toc_link = Connect_Window.document.getElementById(possible_toc_entry_id);
                if (possible_toc_link !== null) {
                    // TOC link located!
                    //
                    result = Browser.FindParentWithTagName(possible_toc_link, 'li');
                }
            }

            // Result found?
            //
            if (result === null) {
                // Check for page ID in TOC
                //
                var toc_page_element = Connect_Window.document.getElementById(page_id);
                if (toc_page_element !== null) {
                    // Found page!
                    //
                    var toc_page_li = Browser.FindParentWithTagName(toc_page_element, 'li');
                    var parent_li = toc_page_li;
                    while (
                           (result === null)
                            &&
                           (parent_li !== null )
                          ) {
                        // Look for TOC entry
                        //
                        var toc_links = parent_li.getElementsByTagName('a');
                        var index;
                        for (index = 0 ; index < toc_links.length ; index++) {
                            // Check link ID
                            //
                            var toc_link = toc_links[index];

                            // Same page?
                            //
                            if (toc_link.id.indexOf(page_id) === 0) {
                                // Locate division between page id and linkid
                                //
                                var division_index = toc_link.id.indexOf(':');
                                if (division_index >= 0) {
                                    // Extract linkid and check it
                                    //
                                    var linkid = toc_link.id.substring(division_index + 1);
                                    var linkid_element = page_document.getElementById(linkid);
                                    if (linkid_element !== null) {
                                        // Success!
                                        //
                                        result = Browser.FindParentWithTagName(toc_link, 'li');
                                        break;
                                    }
                                }
                            }
                            else {
                                // Page changed, entry not found
                                //
                                parent_li = null;
                                break;
                            }
                        }

                        // Advance to next li
                        //
                        if (parent_li !== null ) {
                            parent_li = parent_li.nextSibling;
                            while (
                                   (parent_li !== null)
                                    &&
                                   (parent_li.nodeName.toLowerCase() !== 'li')
                                  ) {
                                parent_li = parent_li.nextSibling;
                            }
                        }
                    }

                    if (result === null) {
                        // Fallback and use page match
                        //
                        result = toc_page_li;
                    }
                }
            }
        }
    }

    return result;
};

Connect.CloneTOCEntries = function(param_node, param_expand_entries, param_highlight) {
    var result;

    // Clone and drop id attribute
    //
    result = param_node.cloneNode(false);

    // Reset id
    //
    Browser.RemoveAttribute(result, 'id', '');

    // Process children
    //
    if (param_node.hasChildNodes()) {
        // Check for children to expand
        //
        var  expand_entry = null;
        if (param_expand_entries.length > 0) {
            expand_entry = param_expand_entries[param_expand_entries.length - 1];
        }

        // Inspect children
        //
        var index;
        for (index = 0 ; index < param_node.childNodes.length ; index++) {
            var child_node = param_node.childNodes[index];
            var cloned_child_node = null;

            // Expand only indentified entries
            //
            if (child_node.nodeName.toLowerCase() === 'ul') {
                // Expand?
                //
                if (param_node === expand_entry) {
                    // Next level
                    //
                    param_expand_entries.pop();
                    cloned_child_node = Connect.CloneTOCEntries(child_node, param_expand_entries, param_highlight);

                    // Append!
                    //
                    result.appendChild(cloned_child_node);

                    // Expand
                    //
                    if (cloned_child_node !== null ) {
                        var entry_div = Browser.PreviousSiblingElementWithTagName(cloned_child_node, 'div');
                        if (
                            (entry_div !== null)
                             &&
                            (Browser.ContainsClass(entry_div.className, 'ww_skin_toc_folder'))
                           ) {
                            Connect.TOCFolder_Open(entry_div);
                        }
                    }
                }
            }
            else {
                // Clone child
                //
                cloned_child_node = Connect.CloneTOCEntries(child_node, param_expand_entries, param_highlight);
                if (cloned_child_node !== null ) {
                    // This section is part of the fix for Bug 14297. -Lief 27. April 2011
		    // Ensure folders are collapsed
                    //
                    if (Browser.ContainsClass(cloned_child_node.className, 'ww_skin_toc_folder')) {
                        Connect.TOCFolder_Close(cloned_child_node);
                    }
 
                    // Highlight final expand entry
                    //
                    if (
                        (param_highlight)
                         &&
                        (param_expand_entries.length === 1)
                         &&
                        (param_node === expand_entry)
                         &&
                        (cloned_child_node.nodeName.toLowerCase() === 'div')
                       ) {
                        cloned_child_node.className += ' ww_skin_toc_entry_selected';
                    }

                    // Append!
                    //
                    result.appendChild(cloned_child_node);
                }
            }
        }
    }

    return result;
};

Connect.DefaultContextTOC = function() {
    // Access TOC info
    //
    var toc_ul = Browser.FirstChildElementWithTagName(Connect.toc_div, 'ul');
    if (toc_ul !== null) {
        var toc_top_li = Browser.FirstChildElementWithTagName(toc_ul, 'li');
        if (toc_top_li !== null) {
            // Identify entries to expand
            //
            var expand_entries = [];

            // Check further down
            //
            var toc_nested_ul = Browser.FirstChildElementWithTagName(toc_top_li, 'ul');
            if (toc_nested_ul !== null) {
                var toc_nested_li = Browser.FirstChildElementWithTagName(toc_nested_ul, 'li');
                if (toc_nested_li !== null) {

                    // Add to expansion list and extend scope
                    //
                    expand_entries.push(toc_nested_li);
                }
            }

            // Add to expansion list and extend scope
            //
            expand_entries.push(toc_top_li);

            // Clone and expand TOC entries
            //
            var cloned_node_tree = Connect.CloneTOCEntries(toc_ul, expand_entries, false);
            Connect.navigation_div.appendChild(cloned_node_tree);
        }
    }
};

Connect.RenderContextTOC = function(param_toc_entry) {
    // TOC entry found!
    //
    var parent_ul = Browser.FindParentWithTagName(param_toc_entry, 'ul');
    if (parent_ul !== null) {
        // Expand target entry
        //
        var expand_entries = [];
        expand_entries.push(param_toc_entry);

        // Extend scope to parent?
        //
        var parent_parent_li = Browser.FindParentWithTagName(parent_ul, 'li');
        var parent_parent_ul = Browser.FindParentWithTagName(parent_parent_li, 'ul');
        if (
            (parent_parent_li !== null)
             &&
            (parent_parent_ul !== null)
           ) {
            // Add to expansion list and extend scope
            //
            expand_entries.push(parent_parent_li);
            parent_ul = parent_parent_ul;

            // Extend further up if target entry has no children
            //
            var child_ul = Browser.FirstChildElementWithTagName(param_toc_entry, 'ul');
            if (child_ul === null) {
                // Try to go up one more level
                //
                var parent_parent_parent_li = Browser.FindParentWithTagName(parent_parent_ul, 'li');
                var parent_parent_parent_ul = Browser.FindParentWithTagName(parent_parent_parent_li, 'ul');
                if (
                    (parent_parent_parent_li !== null)
                     &&
                    (parent_parent_parent_ul !== null)
                   ) {
                    // Add to expansion list and extend scope
                    //
                    expand_entries.push(parent_parent_parent_li);
                    parent_ul = parent_parent_parent_ul;
                }
            }
        }

        // Clone and expand TOC entries
        //
        var cloned_node_tree = Connect.CloneTOCEntries(parent_ul, expand_entries, true);
        Connect.navigation_div.appendChild(cloned_node_tree);
    }
};

Connect.ConfigureTOCLevels = function(param_container_element, param_init_openclose) {
    // Configure TOC levels
    //
    Browser.ApplyToChildElementsWithTagName(param_container_element, 'ul', function(param_ul) {
            // Determine level
            //
            var level = 1;
            var current_node = param_ul.parentNode;
            while (current_node !== param_container_element) {
                if (current_node.nodeName.toLowerCase() === 'ul') {
                    level += 1;
                }

                current_node = current_node.parentNode;
            }

            // Update class name
            //
            param_ul.className = "ww_skin_toc_level ww_skin_toc_level_" + level;

            // Initialize open/close
            //
            if (param_init_openclose) {
                if (level === 1) {
                    param_ul.className += " ww_skin_toc_container_open";
                }
                else {
                    param_ul.className += " ww_skin_toc_container_closed";
                }
            }
        }
    );
};

Connect.UpdateContextTOC = function() {
    // Reset navigation container
    //
    Connect.navigation_div.innerHTML = '<div style="line-height: 1px;">&#160;</div>';

    // Determine TOC context
    //
    var toc_entry = Connect.LocateTOCEntry();

    // Render into navigation area
    //
    if (toc_entry !== null) {
        // TOC entry found!
        //
        Connect.RenderContextTOC(toc_entry);

        // Configure TOC levels
        //
        Connect.ConfigureTOCLevels(Connect.navigation_div, false);

        // Intercept all clicks
        //
        Browser.ApplyToChildElementsWithTagName(Connect.navigation_div, 'a', function(param_link) {
                param_link.onclick = Connect.NavigationLink;

                // Track container clicks as well
                //
                param_link.parentNode.onclick = Connect.ContextNavigationEntryClick;
            }
        );

        // This section is part of the fix for Bug 14297. -Lief 27. April 2011
	// Track folder clicks
        //
        Browser.ApplyToChildElementsWithTagName(Connect.navigation_div, 'div', function(param_div) {
                if (Browser.ContainsClass(param_div.className, 'ww_skin_toc_folder')) {
                    param_div.onclick = Connect.ContextNavigationEntryClick;
                }
            }
        );
    }
    else {
        // Default rendering
        //
        Connect.DefaultContextTOC();
    }
};

Connect.ToolbarLink = function(param_event) {
    // Access event
    //
    var event = param_event || window.event;

    // Cancel event bubbling
    //
    event.cancelBubble = true;
    if (event.stopPropagation) {
        event.stopPropagation();
    }
    else {
        event.cancelBubble = true;
    }

    // Process event
    //
    var result = Connect.HandleToolbarLink(this);

    return result;
};

Connect.NavigationLink = function(param_event) {
    // Access event
    //
    var event = param_event || window.event;

    // Cancel event bubbling
    //
    event.cancelBubble = true;
    if (event.stopPropagation) {
        event.stopPropagation();
    }
    else {
        event.cancelBubble = true;
    }

    // Process event
    //
    var result = Connect.HandleInterceptLink(this);
    if (result === true) {
        // Try container onclick handler
        //
        var parent_div = Browser.FindParentWithTagName(this, 'div');
        if (
            (parent_div !== null)
             &&
            (parent_div.onclick !== undefined)
           ) {
            // JavaScript call() to invoke method with designated "this" reference
            //
            result = parent_div.onclick.call(parent_div, event);
        }
    }
    else {
        // Hide panel
        //
        Connect.Panel.Hide();
    }

    return result;
};

Connect.IndexLink = function(param_event) {
    // Access event
    //
    var event = param_event || window.event;

    // Cancel event bubbling
    //
    event.cancelBubble = true;
    if (event.stopPropagation) {
        event.stopPropagation();
    }
    else {
        event.cancelBubble = true;
    }

    // See/See Also link?
    //
    if (this.rel.toLowerCase() === 'see') {
        var hash_index = this.href.indexOf('#');
        if (hash_index >= 0) {
            var see_also_id = this.href.substring(hash_index + 1);

            var index_entry = Connect_Window.document.getElementById(see_also_id);
            if (index_entry !== null) {
                var position_element = index_entry;
                var scrollToLeft = 0;
                var scrollToTop = 0;
                while (position_element !== null) {
                    scrollToLeft += position_element.offsetLeft;
                    scrollToTop += position_element.offsetTop;

                    position_element = position_element.offsetParent;
                }
                Connect_Window.scrollTo(scrollToLeft, scrollToTop);
            }
        }

        result = false;
    }
    else {
        // Document link
        //
        result = Connect.HandleInterceptLink(this);
        if (result !== true) {
            // Hide panel
            //
            Connect.Panel.Hide();
        }
    }

    return result;
};

Connect.TOC_RecordClassState = function(param_element) {
    // Track original class info if enabled
    //
    if (Connect.toc_class_states !== null) {
        // Build key
        //
        var element_key = '';
        var element_in_path = param_element;
        while (
               (element_in_path !== undefined)
                &&
               (element_in_path !== null)
                &&
               (
                (typeof(element_in_path.id) !== 'string')
                 ||
                (element_in_path.id.length === 0)
               )
              ) {
            element_key = element_in_path.nodeName + ':' + element_key;
            element_in_path = element_in_path.parentNode;
        }
        if (
            (element_in_path !== undefined)
             &&
            (element_in_path !== null)
           ) {
            element_key = element_in_path.id + ':' + element_key;
        }

        // Already tracking?
        //
        if ( ! (element_key in Connect.toc_class_states)) {
            Connect.toc_class_states[element_key] = { 'element': param_element, 'className': param_element.className};
        }
    }
};

Connect.TOC_RestoreClassStates = function() {
    if (Connect.toc_class_states !== null) {
        var element_key;
        for (element_key in Connect.toc_class_states) {
            var entry_state = Connect.toc_class_states[element_key];
            entry_state.element.className = entry_state.className;
        }
    }
};

Connect.TOCFolder_Open = function(param_entry_div) {
    if (Browser.ContainsClass(param_entry_div.className, 'ww_skin_toc_folder')) {
        var child_span = Browser.FirstChildElementWithTagName(param_entry_div, 'span');
        if (child_span !== null) {
            Connect.TOC_RecordClassState(child_span);
            child_span.className = child_span.className.replace(' ww_skin_toc_dropdown_closed', ' ww_skin_toc_dropdown_open');
        }
        var sibling_ul = Browser.NextSiblingElementWithTagName(param_entry_div, 'ul');
        if (sibling_ul !== null) {
            Connect.TOC_RecordClassState(sibling_ul);
            sibling_ul.className = sibling_ul.className.replace(' ww_skin_toc_container_closed', ' ww_skin_toc_container_open');
        }
    }
};

Connect.TOCFolder_Close = function(param_entry_div) {
    if (Browser.ContainsClass(param_entry_div.className, 'ww_skin_toc_folder')) {
        var child_span = Browser.FirstChildElementWithTagName(param_entry_div, 'span');
        if (child_span !== null) {
            Connect.TOC_RecordClassState(child_span);
            child_span.className = child_span.className.replace(' ww_skin_toc_dropdown_open', ' ww_skin_toc_dropdown_closed');
        }
        var sibling_ul = Browser.NextSiblingElementWithTagName(param_entry_div, 'ul');
        if (sibling_ul !== null) {
            Connect.TOC_RecordClassState(sibling_ul);
            sibling_ul.className = sibling_ul.className.replace(' ww_skin_toc_container_open', ' ww_skin_toc_container_closed');
        }
    }
};

Connect.TOCFolder_Toggle = function(param_entry_div) {
    if (Browser.ContainsClass(param_entry_div.className, 'ww_skin_toc_folder')) {
        var sibling_ul = Browser.NextSiblingElementWithTagName(param_entry_div, 'ul');
        if (sibling_ul !== null) {
            if (Browser.ContainsClass(sibling_ul.className, 'ww_skin_toc_container_open')) {
                Connect.TOCFolder_Close(param_entry_div);
            }
            else if (Browser.ContainsClass(sibling_ul.className, 'ww_skin_toc_container_closed')) {
                Connect.TOCFolder_Open(param_entry_div);
            }
        }
    }
};

Connect.NavigationEntryClickHandler = function(param_element, param_event, param_icon_click_handler) {
    // Intended for the <div> tag?
    //
    if (param_element.nodeName.toLowerCase() === 'div') {
        // Default action
        //
        var treat_as = '';

        // Access child link
        //
        var child_link = Browser.FirstChildElementWithTagName(param_element, 'a');
        if (
            (child_link !== null)
             &&
            (child_link.href !== '')
           ) {
            // Assume link click
            //
            treat_as = 'link_click';

            // Clicked open/close?
            //
            if (Browser.ContainsClass(param_element.className, 'ww_skin_toc_folder')) {
                var child_span = Browser.FirstChildElementWithTagName(param_element, 'span');
                if (
                    (child_span !== null)
                     &&
                    (Browser.ContainsClass(child_span.className, 'ww_skin_toc_dropdown'))
                   ) {
                    // Treat as icon click!
                    //
                    treat_as = 'icon_click';
                }
            }
        }
        else {
            // Clicked open/close?
            //
            if (Browser.ContainsClass(param_element.className, 'ww_skin_toc_folder')) {
                // Toogle open/close
                //
                treat_as = 'icon_click';
            }
        }

        // Handle click
        //
        if (treat_as === 'icon_click') {
            param_icon_click_handler(param_element);
        }
        else if (treat_as === 'link_click') {
            var page_document = Browser.GetDocument(Connect.page_iframe);
            if (page_document !== undefined) {
                // Hide panel
                //
                Connect.Panel.Hide();

                // Display document as current page
                //
                Connect.DisplayPage(child_link.href);
            }
        }
    }

    return false;
};

Connect.NavigationEntryClick = function(param_event) {
    var result;

    // Access event
    //
    var event = param_event || window.event;

    result = Connect.NavigationEntryClickHandler(this, event, function(param_element) {
            // Toggle open/closed
            //
            Connect.TOCFolder_Toggle(param_element);
        });

    return result;
};

Connect.ContextNavigationEntryClick = function(param_event) {
    var result;

    // Access event
    //
    var event = param_event || window.event;

    result =  Connect.NavigationEntryClickHandler(this, event, function(param_element) {
            if (Browser.ContainsClass(param_element.className, 'ww_skin_toc_folder')) {
                // Closed?
                //
                var child_span = Browser.FirstChildElementWithTagName(param_element, 'span');
                if (
                    (child_span !== null)
                     &&
                    (child_span.className.indexOf('ww_skin_toc_dropdown_closed') >= 0)
                   ) {
                    // Display TOC
                    //
                    Connect_Window.setTimeout(Connect.Button_TOC, 1);
                }
            }
        });

    return result;
};

Connect.DisplayPage = function(param_href) {
    var page_document = Browser.GetDocument(Connect.page_iframe);
    if (page_document !== undefined) {
        // Page load in progress
        //
        Connect.page_loading = true;

        // Determine desired hash
        //
        var desired_hash = '';
        if (param_href.indexOf('#') !== -1) {
            desired_hash = param_href.substring(param_href.indexOf('#'));
        }

        // Load new document or update hash
        //
        var same_document = Browser.SameDocument(page_document.location.href, param_href);
        if (same_document) {
            // Update hash
            //
            page_document.location.hash = desired_hash;

            // Document bookkeeping
            //
            Connect.DocumentBookkeeping(true);

            // Page load complete
            //
            Connect.page_loading = false;
        }
        else {
            // Simulate page load
            //
            Connect.navigation_div_bottom.style.display = 'none';
            Connect.page_div.style.visibility = 'hidden';

            // Display document as page
            //
            page_document.location.replace(param_href);
        }
    }
};

Connect.InterceptLink = function(param_event) {
    var result;

    result = Connect.HandleInterceptLink(this);

    return result;
};

Connect.HandleToolbarLink = function(param_link) {
    var result = true;

    if (typeof(param_link.className) === 'string') {
        if (Browser.ContainsClass(param_link.className, 'ww_behavior_toc')) {
            // TOC Link
            //
            Connect.Button_TOC();
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_index')) {
            // Index Link
            //
            Connect.Button_Index();
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_search')) {
            // Search Link
            //
            Connect.Button_Search();
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_globe')) {
            // Globe Link
            //
            Connect.Button_Globe();
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_prev')) {
            // Previous
            //
            Connect.GotoPrevNext('Prev');
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_next')) {
            // Next
            //
            Connect.GotoPrevNext('Next');
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_email')) {
            // Email
            //
            Connect.Button_Email();
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_print')) {
            // Print
            //
            Connect.Button_Print();
            result = false;
        }
        else if (Browser.ContainsClass(param_link.className, 'ww_behavior_pdf')) {
            // PDF
            //
            Connect.Button_PDF();
            result = false;
        }
    }

    return result;
};

Connect.HandleInterceptLink = function(param_link) {
    var result = true;

    result = Connect.HandleToolbarLink(param_link);
    if (result === true) {
        if (Browser.GetAttribute(param_link, 'wwx:original-href') !== null) {
            // Thumbnail link?
            //
            Connect.DisplayFullsizeImage(param_link);
            result = false;
        }
        else {
            // Standard link
            //
            var page_document = Browser.GetDocument(Connect.page_iframe);
            if (
                (page_document !== undefined)
                 &&
                (param_link.href !== undefined)
                 &&
                (param_link.href !== null)
                 &&
                (param_link.href !== '')
               ) {
                // Display document as current page
                //
                Connect.DisplayPage(param_link.href);
                result = false;
            }
        }
    }

    return result;
};

Connect.DocumentBookkeeping = function(param_same_document) {
    // Determine relative path
    //
    var page_document = Browser.GetDocument(Connect.page_iframe);
    if (page_document !== undefined) {
        // Update hash
        //
        if (Browser.SameHierarchy(Connect.base_url, page_document.location.href)) {
            var relative_path = Browser.RelativePath(Connect.base_url, page_document.location.href);
            var page_hash = '#page/' + encodeURI(relative_path);

            // Splash page?
            //
            if (Browser.SameDocument(Connect.default_page_url, page_document.location.href)) {
                if (
                    (Connect_Window.location.hash == page_hash)
                     ||
                    (Connect_Window.location.hash == decodeURI(page_hash))
                     ||
                    (Connect_Window.location.hash === '')
                   ) {
                    // No change!
                    //
                    page_hash = Connect_Window.location.hash;
                }
            }

            if (
                (Connect_Window.location.hash != page_hash)
                 &&
                (Connect_Window.location.hash != decodeURI(page_hash))
               ) {
                // Update hash
                //
                Connect_Window.location.hash = page_hash;
            }
        }

        // Track current hash
        //
        Connect.hash = Connect_Window.location.hash;

        // Update anchors
        //
        Connect.UpdateAnchors(page_document);

        // Update navigation
        //
        Connect.UpdateContextTOC();

        // Scroll to top if necessary
        //
        if (page_document.location.hash === '') {
            Connect_Window.scroll(0, 0);
        }

        // Make visible
        //
        Connect.page_div.style.visibility = 'visible';

        // Adjust for content size
        //
        if (param_same_document) {
            Connect.AdjustLayoutForBrowserSize();
        }
        else {
            Connect.AdjustForContentSize();
        }
    }
};

Connect.Globalize = function() {
    var iframe_document = Browser.GetDocument(Connect.page_iframe);
    if (iframe_document !== undefined) {
        // Google Translation
        //
        if (Connect.globe_enabled) {
            var google_translate_div = iframe_document.getElementById('google_translate_element');
            if (google_translate_div !== null) {
                var google_translate_script = iframe_document.createElement('script');
                google_translate_script.type = 'text/javascript';
                google_translate_script.async = true;
                google_translate_script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
                google_translate_div.appendChild(google_translate_script);
            }
        }
    }
};

Connect.Socialize = function() {
    var iframe_document = Browser.GetDocument(Connect.page_iframe);
    if (iframe_document !== undefined) {
        // Twitter
        //
        var twitter_span = iframe_document.getElementById('social_twitter');
        if (twitter_span !== null) {
            var twitter_iframe = Browser.FirstChildElementWithTagName(twitter_span, 'iframe');
            if (twitter_iframe !== null) {
                twitter_iframe.src = 'http://platform.twitter.com/widgets/tweet_button.html?lang=en&count=horizontal&url=' + encodeURI(iframe_document.location.href);
            }
        }

        // FaceBook Like
        //
        var facebook_span = iframe_document.getElementById('social_facebook_like');
        if (facebook_span !== null) {
            var facebook_iframe = Browser.FirstChildElementWithTagName(facebook_span, 'iframe');
            if (facebook_iframe !== null) {
                facebook_iframe.src = 'http://www.facebook.com/plugins/like.php?locale=en&layout=button_count&show_faces=false&action=like&colorscheme=light&width=90&height=20&href=' + encodeURI(iframe_document.location.href);
            }
        }

        // Disqus
        //
        if (Connect.disqus_id.length > 0) {
            var disqus_div = iframe_document.getElementById('disqus_thread');
            if (disqus_div !== null) {
                var disqus_script = iframe_document.createElement('script');
                disqus_script.type = 'text/javascript';
                disqus_script.async = true;
                disqus_script.src = 'http://' + Connect.disqus_id + '.disqus.com/embed.js';
                disqus_div.parentNode.appendChild(disqus_script);
            }
        }
    }
};

Connect.AdjustForSearchContentSize = function() {
    // Search panel active?
    //
    if (Connect.search_div.parentNode !== Connect.panels_div) {
        // Set content height
        //
        var search_widthheight = Browser.GetIFrameContentWidthHeight(Connect.search_iframe);
        Connect.search_iframe.style.height = '' + search_widthheight.height + 'px';
    }
};

Connect.OnSearchLoad = function() {
    // Track document size changes
    //
    var search_document = Browser.GetDocument(Connect.search_iframe);
    if (search_document !== undefined) {
        Browser.TrackDocumentChanges(search_document, Connect.AdjustForSearchContentSize);

        // Define search dismiss behavior
        //
        search_document.Connect_HandleSearchLinkClick = function(param_link) {
                // Queue page for display
                //
                Connect.Panel.page_url = param_link.href;

                // Shutdown panel
                //
                Connect_Window.setTimeout(Connect.Button_Search, 1);
            };

        // Define search complete behavior
        //
        search_document.Connect_HandleSearchComplete = function() {
                Connect_Window.setTimeout(Connect.AdjustForSearchContentSize, 1);
            };

        // Execute search
        //
        if (
            (Connect.search_words_onload !== undefined)
             &&
            (search_document.Connect_Execute_Search !== undefined)
           ) {
            // Added per Bug 14375 -Lief
	    // Identify search start page
            //
            var page_location_href = '';
            var page_document = Browser.GetDocument(Connect.page_iframe);
            if (page_document !== undefined) {
                page_location_href = page_document.location.href;
            }

            // Search
            //
            search_document.Connect_Execute_Search(Connect.search_words_onload, page_location_href);
            Connect.search_words_onload = undefined;
        }
    }
};

Connect.UpdatePrevNextButton = function(param_button_behavior, param_link_rel) {
    var button_span = Connect.buttons[param_button_behavior];
    if (button_span !== undefined) {
        var button_a = Browser.FirstChildElementWithTagName(button_span, 'a');
        if (button_a !== null) {
            var prevnext_link = Connect.GetPrevNext(param_link_rel);
            var enabled_class = ' ww_skin_' + param_link_rel.toLowerCase() + '_enabled';
            var disabled_class = ' ww_skin_' + param_link_rel.toLowerCase() + '_disabled';

            // Update class name
            //
            var updated_className = button_a.className.replace(enabled_class, '').replace(disabled_class, '');
            if (prevnext_link !== undefined) {
                // Enable
                //
                updated_className += enabled_class;
            }
            else {
                // Disable
                //
                updated_className += disabled_class;
            }
            button_a.className = updated_className;
        }
    }
};

Connect.OnDocumentLoad = function() {
    // Environment initialized?
    //
    if (Connect.parcels_loaded) {
        // Document bookkeeping
        //
        Connect.DocumentBookkeeping(false);

        // Track document size changes
        //
        var page_document = Browser.GetDocument(Connect.page_iframe);
        if (page_document !== undefined) {
            Browser.TrackDocumentChanges(page_document, Connect.OnResize);

            // Update window title
            //
            Connect_Window.document.title = page_document.title;
        }

        // Update prev/next
        //
        Connect.UpdatePrevNextButton('ww_behavior_prev', 'Prev');
        Connect.UpdatePrevNextButton('ww_behavior_next', 'Next');

        // Socialize and Globalize
        //
        Connect_Window.setTimeout(function() { Connect.Socialize(); Connect.Globalize(); }, 1);

        // Page load complete
        //
        Connect.page_loading = false;
    }
};

Connect.UpdateAnchors = function(param_page_document) {
    var index;
    for (index = 0; index < param_page_document.links.length ; index++) {
        var link = param_page_document.links[index];

        // Update targets
        //
        if (Browser.SameHierarchy(Connect.base_url, link.href)) {
            // Verify parcel is known
            //
            if (Connect.KnownParcelURL(link.href)) {
                // Parcel is known
                //
                link.onclick = Connect.InterceptLink;
            }
            else {
                // Unknown parcel, kill link
                //
                Browser.RemoveAttribute(link, 'href', '');
            }
        }
        else {
            // Link to external (non-parcel) content
            //

            // Assign window target if not already defined
            //
            if (
                (link.target === undefined)
                 ||
                (link.target === null)
                 ||
                (link.target === '')
               ) {
                // Replace current window
                //
                link.target = Connect_Window.name;
            }
        }
    }
};

Connect.DisplayFullsizeImage = function(param_link) {
    var iframe_document = Browser.GetDocument(Connect.page_iframe);
    if (iframe_document !== undefined) {
        var browser_widthheight;
        var original_widthheight;

        // Retrieve width/height info
        //
        browser_widthheight = Browser.GetBrowserWidthHeight();
        original_widthheight = { width: parseInt(Browser.GetAttribute(param_link, 'wwx:original-width'), 10), height: parseInt(Browser.GetAttribute(param_link, 'wwx:original-height'), 10) };

        // Enough room for lightbox?
        //
        if (
            ((original_widthheight.width + Connect.lightbox_min_pixel_margin) < browser_widthheight.width)
             &&
            ((original_widthheight.height + Connect.lightbox_min_pixel_margin) < browser_widthheight.height)
           ) {
            var original_href;
            var resolved_link_href;
            var fullsize_image;

            // Resolve path to full-size image
            //
            original_href = Browser.GetAttribute(param_link, 'wwx:original-href');
            resolved_link_href = Browser.ResolveURL(iframe_document.location.href, original_href);

            // Create image to display
            //
            fullsize_image = Connect_Window.document.createElement('img');
            Browser.SetAttribute(fullsize_image, 'width', original_widthheight.width);
            Browser.SetAttribute(fullsize_image, 'height', original_widthheight.height);
            Browser.SetAttribute(fullsize_image, 'src', resolved_link_href);

            // Display lightbox
            //
            Connect.Lightbox.Display(function(param_lightbox_content) {
                        param_lightbox_content.appendChild(fullsize_image);
                    },
                    function(param_lightbox_content) {
                        param_lightbox_content.innerHTML = '';
                    }
                );
        }
        else {
            // Replace displayed document
            //
            Connect.DisplayPage(param_link.href);
        }
    }
};

Connect.Button_TOC = function() {
    if ( ! Connect.Panel.Visible()) {
        // Show
        //
        var button_span = Connect.buttons['ww_behavior_toc'];

        Connect.Panel.Display(function(param_window, param_panel_content) {
                    // Highlight toolbar button
                    //
                    if (button_span !== undefined) {
                        button_span.className = button_span.className.replace('ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
                    }

                    // Determine TOC context
                    //
                    var toc_entry = Connect.LocateTOCEntry();

                    // Track class states
                    //
                    Connect.toc_class_states = {};

                    // Expand TOC for context
                    //
                    if (toc_entry !== null) {
                        // Highlight entry
                        //
                        var entry_div = Browser.FirstChildElementWithTagName(toc_entry, 'div');
                        if (entry_div !== null) {
                            // Highlight
                            //
                            Connect.TOC_RecordClassState(entry_div);
                            entry_div.className += ' ww_skin_toc_entry_selected';

                            // Expand entry and parents
                            //
                            Connect.TOCFolder_Open(entry_div);
                            var parent_ul = Browser.FindParentWithTagName(entry_div, 'ul');
                            while (parent_ul !== null) {
                                var parent_entry_div = Browser.PreviousSiblingElementWithTagName(parent_ul, 'div');
                                if (parent_entry_div !== null) {
                                    Connect.TOCFolder_Open(parent_entry_div);
                                }

                                parent_ul = Browser.FindParentWithTagName(parent_ul, 'ul');
                            }
                        }
                    }

                    // On Stage
                    //
                    param_panel_content.appendChild(Connect.toc_div);
                },
                function(param_window, param_panel_content) {
                    // Backstage
                    //
                    Connect.panels_div.appendChild(Connect.toc_div);

                    // Restore class info
                    //
                    Connect.TOC_RestoreClassStates();

                    // Stop tracking class states
                    //
                    Connect.toc_class_states = null;

                    // Highlight toolbar button
                    //
                    if (button_span !== undefined) {
                        button_span.className = button_span.className.replace('ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
                    }
                }
            );
    }
    else {
        // Hide
        //
        Connect.Panel.Hide();
    }
};

Connect.Button_Index = function() {
    if ( ! Connect.Panel.Visible()) {
        // Show
        //
        var button_span = Connect.buttons['ww_behavior_index'];

        Connect.Panel.Display(function(param_window, param_panel_content) {
                    // Highlight toolbar button
                    //
                    if (button_span !== undefined) {
                        button_span.className = button_span.className.replace('ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
                    }

                    // On Stage
                    //
                    if (Connect.parcel_ix.length > 0) {
                        // Show progress
                        //
                        Connect.panel_progress_div.innerHTML = '';
                        var progress_div = Connect_Window.document.getElementById('progress');
                        Connect.panel_progress_div.appendChild(progress_div);
                        param_panel_content.appendChild(Connect.panel_progress_div);
                        Progress.Reset();

                        // Initiate index load
                        //
                        Connect.index_div.innerHTML = '';
                        Connect_Window.setTimeout(Connect.Index_Load, 1);
                    }
                    else {
                        // Show index
                        //
                        param_panel_content.appendChild(Connect.index_div);
                    }
                },
                function(param_window, param_panel_content) {
                    // Backstage
                    //
                    Connect.panels_div.appendChild(Connect.index_div);

                    // Highlight toolbar button
                    //
                    if (button_span !== undefined) {
                        button_span.className = button_span.className.replace('ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
                    }
                }
            );
    }
    else {
        // Hide
        //
        Connect.Panel.Hide();
    }
};

Connect.Index_Load = function() {
    var ajaxdata = new AJAXData_Object(Connect.parcel_ix,
            function(param_entry) {
                return param_entry.url;
            },
            function(param_percent) {
                Progress.Update(param_percent);
            },
            function(param_entry, param_ajax) {
                // Access parcel data
                //
                var parcel_data = Connect_Window.document.createElement('div');
                parcel_data.style.visibility = 'hidden';
                parcel_data.innerHTML = param_ajax.responseText;
                Connect_Window.document.body.appendChild(parcel_data);

                // Index
                //
                var parcel_index_div_id = 'index:' + param_entry.id;
                var parcel_index_div = Connect_Window.document.getElementById(parcel_index_div_id);
                if (parcel_index_div !== null) {
                    var parcel_entry_div = Connect_Window.document.createElement('div');
                    parcel_entry_div.className = 'ww_skin_index_title';
                    parcel_entry_div.innerHTML = Connect.parcel_title[param_entry.id];
                    Connect.index_div.appendChild(parcel_entry_div);
                    Connect.index_div.appendChild(parcel_index_div);
                }

                // Remove parcel data
                //
                Connect_Window.document.body.removeChild(parcel_data);
            },
            function() {
                // Parcel indexes loaded!
                //
                Connect.parcel_ix = [];

                // Intercept all clicks
                //
                Browser.ApplyToChildElementsWithTagName(Connect.index_div, 'a', function(param_link) {
                        param_link.onclick = Connect.IndexLink;
                    }
                );

                // Done!
                //
                Progress.Complete();
                var progress_div = Connect_Window.document.getElementById('progress');
                Connect.panels_div.appendChild(Connect.panel_progress_div);
                Connect_Window.document.body.appendChild(progress_div);

                // On stage!
                //
                Connect.Panel.panel_content.appendChild(Connect.index_div);
            }
        );
    ajaxdata.Execute();
};

Connect.Button_Search = function(param_search_words, param_page_url) {
    if ( ! Connect.Panel.Visible()) {
        // Show
        //
        var button_span = Connect.buttons['ww_behavior_search'];

        Connect.Panel.Display(function(param_window, param_panel_content) {
                    // Highlight toolbar button
                    //
                    if (button_span !== undefined) {
                        button_span.className = button_span.className.replace('ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
                    }

                    // Track default return page
                    //
                    Connect.Panel.page_url = param_page_url;

                    // Hide search input
                    //
                    if (Connect.search_input !== null) {
                        Connect.search_input.style.display = 'none';
                    }

                    // Get search words
                    //
                    var search_words = '';
                    if (
                        (param_search_words !== undefined)
                         &&
                        (typeof(param_search_words) === 'string')
                       ) {
                        search_words = param_search_words;
                    }
                    else {
                        if (
                            (Connect.layout_wide)
                             &&
                            (Connect.search_input !== null)
                           ) {
                            search_words = Connect.search_input.value;
                        }
                    }

                    // Update search words
                    //
                    Connect.search_words_onload = search_words;

                    // On Stage
                    //
                    param_panel_content.appendChild(Connect.search_div);

                    // Execute search
                    //
                    if (Connect.search_iframe.src != Connect.search_page_url) {
                        // Load page
                        //
                        Connect.search_iframe.src = Connect.search_page_url;
                    }
                    else {
                        var search_document = Browser.GetDocument(Connect.search_iframe);
                        if (
                            (search_document !== undefined)
                             &&
                            (search_document.Connect_Execute_Search !== undefined)
                           ) {
                             // Added per Bug 14375 -Lief
			     // Identify search start page
                             //
                             var page_location_href = '';
                             var page_document = Browser.GetDocument(Connect.page_iframe);
                             if (page_document !== undefined) {
                                 page_location_href = page_document.location.href;
                             }

                             // Search
                             //
                             search_document.Connect_Execute_Search(search_words, page_location_href);
                        }
                    }
                },
                function(param_window, param_panel_content) {
                    // Restore search input
                    //
                    if (Connect.search_input !== null) {
                        // Update search words
                        //
                        var search_document = Browser.GetDocument(Connect.search_iframe);
                        if (search_document !== undefined) {
                            if (search_document.Connect_Search_Words !== undefined) {
                                Connect.search_input.value = search_document.Connect_Search_Words;
                            }
                        }

                        if (Connect.layout_wide) {
                            Connect.search_input.style.display = 'inline';
                        }
                        else {
                            Connect.search_input.style.display = 'none';
                        }
                    }

                    // Backstage
                    //
                    Connect.panels_div.appendChild(Connect.search_div);

                    // Highlight toolbar button
                    //
                    if (button_span !== undefined) {
                        button_span.className = button_span.className.replace('ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
                    }
                }
            );
    }
    else {
        // Hide
        //
        Connect.Panel.Hide();

        // Display specified page
        //
        if (Connect.Panel.page_url !== undefined) {
            Connect.DisplayPage(Connect.Panel.page_url);
            Connect.Panel.page_url = undefined;
        }
    }
};

Connect.Button_Globe = function() {
    // Enabled?
    //
    var button_span = Connect.buttons['ww_behavior_globe'];
    if ( ! Connect.globe_enabled) {
        // Highlight toolbar button
        //
        if (button_span !== undefined) {
            button_span.className = button_span.className.replace('ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
        }

        // Globalize
        //
        Connect.globe_enabled = true;
        Connect_Window.setTimeout(Connect.Globalize, 1);
    }
    else {
        // Disable globalization
        //
        Connect.globe_enabled = false;
        var page_document = Browser.GetDocument(Connect.page_iframe);
        if (page_document !== undefined) {
            Connect_Window.setTimeout(function() { page_document.location.reload(); }, 1);
        }

        // Highlight toolbar button
        //
        if (button_span !== undefined) {
            button_span.className = button_span.className.replace('ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
        }
    }
};

Connect.GetPrevNext = function(param_prevnext) {
    var result;

    try {
        var iframe_document = Browser.GetDocument(Connect.page_iframe);
        if (iframe_document !== undefined) {
            var link_href = Browser.GetLinkRelHREF(iframe_document, param_prevnext);
            if (
                (link_href !== '')
                 &&
                (link_href !== '#')
               ) {
                // Ensure link is fully resolved
                // (workaround IE's compatibility view)
                //
                result = Browser.ResolveURL(iframe_document.location.href, link_href);
            }
            else {
                // Spanning parcels?
                //
                if (Connect.link_bridge.Get(param_prevnext, iframe_document.body.id) !== null) {
                    result = Connect.link_bridge.Get(param_prevnext, iframe_document.body.id);
                }
            }
        }
    }
    catch (e) {
        // Ignore all errors!
        //
    }

    return result;
};

Connect.GotoPrevNext = function(param_prevnext) {
    var link_href = Connect.GetPrevNext(param_prevnext);
    if (link_href !== undefined) {
        Connect.DisplayPage(link_href);
    }
};

Connect.Button_Email = function() {
    if (Connect.email.length > 0) {
        var page_document = Browser.GetDocument(Connect.page_iframe);
        if (page_document !== undefined) {
            var location = encodeURI(Connect_Window.location.href);
            var message = 'Feedback: ' + location;
            var mailto = 'mailto:' + Connect.email + '?subject=' + message + '&body=' + message;

            page_document.location = mailto;
        }
    }
};

Connect.Button_Print = function() {
    var page_window = Connect.page_iframe.contentWindow || Connect_Window.frames['connect_page'];
    if (
        (page_window !== undefined)
         &&
        (page_window !== null)
       ) {
        page_window.print();
    }
};

Connect.Button_PDF = function() {
    // Find PDF link
    //
    var pdf_link = null;

    var page_document = Browser.GetDocument(Connect.page_iframe);
    if (page_document !== undefined) {
        var links = page_document.body.getElementsByTagName('a');
        var index;
        for (index = 0 ; index < links.length ; index++) {
            var link = links[index];

            if (
                (Browser.ContainsClass(link.className, 'ww_behavior_pdf'))
                 &&
                (link.href !== undefined)
                 &&
                (link.href.length > 0)
               ) {
                // Found our link!
                //
                pdf_link = link;
                break;
            }
        }
    }

    // PDF link found?
    //
    if (pdf_link !== null) {
        // Display PDF
        //
        if (
            (pdf_link.target === undefined)
             ||
            (pdf_link.target === null)
             ||
            (pdf_link.target === '')
             ||
            (pdf_link.target === 'connect_page')
           ) {
            // Use existing page iframe
            //
            Connect.DisplayPage(pdf_link.href);
        }
        else {
            // Display in requested window
            //
            Connect_Window.open(pdf_link.href, pdf_link.target);
        }
    }
};
